<?php if (statusModule('publish', 'events') == 1) { ?>

    <?php $eventsToday = eventsNext($setting->next_events_l); ?>
    <?php if ($eventsToday) { ?>
        <section class="mb-4 col-md-<?php echo $widget->col; ?>">
            <h2 class="title"><?php echo $_LANG['events-next']; ?></h2>
            <div class="row">
                <?php foreach ($eventsToday as $event) { ?>
                    <div class="col-lg-4 col-md-6 col-sm-6 col-6">
                        <article class="card article-card">
                            <a class="link-article" href="<?php echo PATH_SYSTEM . "events/view/" . $event->id . '-' . $event->url; ?>" aria-label="<?php echo $event->title; ?>"></a>
                            <img loading="lazy" src="<?php echo PATH_SYSTEM . "public/event/" . $event->thumbnail; ?>" class="img-fluid rounded-start" alt="<?php echo $event->title; ?>">
                            <div class="card-body">
                                <span class="datatime">
                                    <?php
                                    $dateStart = FormatDate('D,d,F', $event->date_start);
                                    $dateEnd = FormatDate('D,d,F', $event->date_end);
                                    $timeStart = FormatDate($setting->format_time, $event->date_start);
                                    $timeEnd = FormatDate($setting->format_time, $event->date_end);

                                    if ($dateStart == $dateEnd) {
                                        $dateStart = explode(',', $dateStart);
                                        echo $_LANG[$dateStart[0] . '_short'] . ', ' . $dateStart[1] . ' ' . $_LANG[$dateStart[2] . '_short'] . ' · ' . $timeStart;
                                    } else {
                                        $dateEnd = explode(',', $dateEnd);
                                        $dateStart = explode(',', $dateStart);
                                        echo $dateStart[1] . ' ' . $_LANG[$dateStart[2] . '_short'] . '<span class="divider"> <i class="fas fa-angle-right"></i> </span>' . $dateEnd[1] . ' ' . $_LANG[$dateEnd[2] . '_short'];
                                    }
                                    ?>
                                </span>
                                <h3 class="card-title"><?php echo $event->title; ?></h3>
                                <span class="location card-text"><?php echo $event->location; ?></span>
                            </div>

                            <span class="label"><label class="badge text-bg-primary"><?php echo $_LANG['next']; ?></label></span>

                        </article>
                    </div>
                <?php } ?>
            </div>
        </section>
    <?php } ?>

<?php } ?>
